*******************************************************************************/

cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Time Varying Models\Replicating Frontier Analysis\Table 2 - sfpanel bc"
capture log close
log using "log/Benchmarking 2025-04-14-longperiod", replace
* AER VC CD & TLG LSE & SFA models, common time trend
* Australian DNSP identifiers are 1 ACT, 2 AGD, 3 CIT, 4 END, 5 ENX, 6 ERG, 7 ESS, 8 JEN, 9 PCR, 10 SAP, 11 AND, 12 TND, 13 UED
*version 14
clear
set more off
* set maxiter 2000



/*****************************************************************************
	1.  Transform data and estimate models
******************************************************************************/

set more off
local startyr 2006
local endyr   2023

scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.219668445
scalar define propex_rebase_canada = 1.160126855  

* Import opex benchmarking data from Final 2024 ABR 
use dta\DNSPopex24.dta, clear
describe

xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
replace dnsp = 13+eiid - 2000 if country == 2
replace dnsp = 32+eiid - 3000 if country == 3
qui tabulate dnsp, gen(d)

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

* Sample selection
*-------------------------

drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------

generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

gen lastob = 0
replace lastob = 1 if dnsp != dnsp[_n+1]

* Regression log variables

gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen lz1 = log(shareugc)

* mean correct output data
qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3

if `startyr'==2006{
preserve
keep if d1==1
keep if yr==2006
keep mly1 mly2 mly3
export delimited using "output/Means.csv", replace
restore
}
* TLG variables

gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly33 = (ly3^2)/2

* Interaction between time trend and jurisdiction
gen jur1_yr=jur1*yr
gen jur2_yr=jur2*yr
gen jur3_yr=jur3*yr


* JTT model - TL - Use SFPanel
qui reg lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 jur1_yr jur2_yr jur3_yr jur2 jur3
matrix b0 =e(b)
sfpanel lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 jur1_yr jur2_yr jur3_yr jur2 jur3, model(bc88) cost svfrontier(b0) svemean(0.1) svsigma(ln(e(rmse)^2)) svgamma(0.1)
/*putexcel set "output/Results.xls", sheet(JTT_TL_SFPanel) modify
putexcel A1=matrix(e(b)), names
putexcel A16=matrix(e(N)), names
putexcel A20=matrix(e(ll)), names*/
predict eff_jtt_tl_alt, bc
********************************************************************************

* Build up to sfpanel BC95 of translog, with all DNSP dummies and three coutnry time trends for the inefficiency (single cost function time trend)

* First, the BC88 model
qui reg lvc ly1 ly2 ly3 lz1 yr jur2 jur3
matrix b0 =e(b)
sfpanel lvc ly1 ly2 ly3 lz1 yr jur2 jur3, model(bc88) cost svfrontier(b0) svemean(0.1) svsigma(ln(e(rmse)^2)) svgamma(0.1)
matrix b0 =e(b)
matrix b_Frontier=b0[1,"Frontier:"]
matrix b_MuCons=b0[1,"Mu:_cons"]
matrix b_U=b0[1,"Sigma:"]
matrix b_V=b0[1,"Sigma:"]

* A simple BC95 model i.e. not utilising the panel aspect
sfpanel lvc ly1 ly2 ly3 lz1 yr jur2 jur3, model(bc95) cost svfrontier(b_Frontier) svemean(b_MuCons) svusigma(b_U) svvsigma(b_V) iter(1000)
matrix b0 =e(b)
matrix b_Frontier=b0[1,"Frontier:"]
matrix b_MuCons=b0[1,"Mu:_cons"]
matrix b_e=  0,0,0,0,0,0,0,0,0,0,  0,0,0,0,0,0,0,0,0,0,  0,0,0,0,0,0,0,0,0,0,  0,0,0,0,0,0,0,0,0,0,  0,0,0,0,0,0,0,0,0,0,  0,0,0,0,0,0,0,0,0,0,  b_MuCons
matrix b_U=b0[1,"Usigma:"]
matrix b_V=b0[1,"Vsigma:"]

* BC95 model but let the mean depend on the DNSP (all countries' DNSPs have dummies)
sfpanel lvc ly1 ly2 ly3 lz1 yr jur2 jur3, model(bc95) emean(d1-d60) cost svfrontier(b_Frontier) svemean(b_e) svusigma(b_U) svvsigma(b_V) iter(1000) technique(dfp)
matrix b0=e(b)
matrix b_Frontier=b0[1,"Frontier:"]
matrix bm=b0[1,"Mu:"]
matrix b_Mu=bm[1,1..60]
matrix b_MuCons=bm[1,"Mu:_cons"]
matrix b_e=b_Mu, 0,0,0, b_MuCons
matrix b_U=b0[1,"Usigma:"]
matrix b_V=b0[1,"Vsigma:"]

gen aus_yr = yr-2014.5 if country== 1
replace aus_yr = 0 if country!= 1
gen nz_yr = yr-2014.5 if country== 2
replace nz_yr = 0 if country!= 2
gen ont_yr = yr-2014.5 if country== 3
replace ont_yr = 0 if country!= 3

* Add time trends for inefficiency - country specific time trends
sfpanel lvc ly1 ly2 ly3 lz1 yr jur2 jur3, model(bc95) emean(d1-d60 aus_yr nz_yr ont_yr) cost svfrontier(b_Frontier) svemean(b_e) svusigma(b_U) svvsigma(b_V) iter(1000) technique(dfp)
matrix b0=e(b)
matrix bf=b0[1,"Frontier:"]
matrix b_Frontier=bf[1,1..3], 0, 0, 0, 0, 0, 0, bf[1,4..8]
matrix b_e=b0[1,"Mu:"]
matrix b_U=b0[1,"Usigma:"]
matrix b_V=b0[1,"Vsigma:"]

predict bc, bc ci 
table (dnsp) (var) if inrange(dnsp, 1, 13), stat(mean bc bc_LB95 bc_UB95)

*Charts	
twoway (line bc year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line bc year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line bc year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line bc year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line bc year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line bc year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line bc year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line bc year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line bc year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line bc year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line bc year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line bc year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line bc year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") ///
              title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       

* Translog specification
sfpanel lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3, model(bc95) emean(d1-d60 aus_yr nz_yr ont_yr) cost svfrontier(b_Frontier) svemean(b_e) svusigma(b_U) svvsigma(b_V) iter(1000) technique(dfp)
/*putexcel set "output/Results.xls", sheet(BC95) modify
putexcel A1=matrix(e(b)), names
putexcel A16=matrix(e(N)), names
putexcel A20=matrix(e(ll)), names*/

* Output elasticities	
	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) p(p3)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

label var ely1 "ely1"
label var ely2 "ely2"
label var ely3 "ely3"
label var elY  "elY"
label var lw_y1 "lw_y1"
label var up_y1 "up_y1"
label var lw_y2  "lw_y2"
label var up_y2  "up_y2"
label var lw_y3  "lw_y3"
label var up_y3  "up_y3"
label var lw_Y  "lw_Y"
label var up_Y  "up_Y"

*Monotonicty	
display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1

table (country) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.3f)
table (dnsp) (var) , stat(mean mon1 mon2 mon3 montot) nformat(%5.3f)



predict eff_BC95, bc
table (dnsp) (var) if inrange(dnsp, 1, 13), stat(mean eff_BC95)


*Charts	
twoway (line eff_BC95 year if dnsp == 1,  sort lcolor(blue)      lpattern(solid)       lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 2,  sort lcolor(red)       lpattern(dash)        lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 3,  sort lcolor(green)     lpattern(longdash)    lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 4,  sort lcolor(orange)    lpattern(longdash)    lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 5,  sort lcolor(maroon)    lpattern(solid)       lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 6,  sort lcolor(teal)      lpattern(dash)        lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 7,  sort lcolor(magenta)   lpattern(longdash)    lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 8,  sort lcolor(dkgreen)   lpattern(solid)       lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 9,  sort lcolor(purple)    lpattern(solid)       lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 10, sort lcolor(brown)     lpattern(dash)        lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 11, sort lcolor(navy)      lpattern(longdash)    lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 12, sort lcolor(pink)      lpattern(solid) 	  lwidth(0.5)) ///
       (line eff_BC95 year if dnsp == 13, sort lcolor(olive)     lpattern(solid)       lwidth(0.5)), ///
       legend(order(1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" ///
                    6 "ERG" 7 "ESS" 8 "JEN" 9 "PCR" 10 "SAP" ///
                    11 "AND" 12 "TND" 13 "UED") ///
              title("DNSP")) ///
       xtitle("Year") ytitle("Efficiency Score") ///
       xlabel(`startyr'(1)`endyr', angle(90) grid)  /// 
       ylabel(0(0.1)1, grid) /// 
       xscale(range(`startyr' `endyr')) /// 
       yscale(range(0 1))       



* Nothing for Powercor or United - this is caused by having a very large negative mu for those two DNSPs which leads to zero divided by zero error in the conditional expection of U (eqn 12 of BC1988)
summarize eff_BC95 if eiid==1009 | eiid==1013
* Rearranging the BC1988 formula to use the lognormal functionality in Stata, this avoids the 0/0 error
predict lvchat, xb
gen resid_BC95=lvc-lvchat
matrix b0=e(b)
matrix b_e=b0[1,"Mu:"]
matrix b_U=b0[1,"Usigma:"]
matrix b_V=b0[1,"Vsigma:"]
gen double mu = b_e[1,64]+b_e[1,61]*aus_yr+b_e[1,1]*d1+b_e[1,2]*d2+b_e[1,3]*d3+b_e[1,4]*d4+b_e[1,5]*d5+b_e[1,6]*d6+b_e[1,7]*d7+b_e[1,8]*d8+b_e[1,9]*d9+b_e[1,10]*d10+b_e[1,11]*d11+b_e[1,12]*d12+b_e[1,13]*d13
matrix list b_U
gen double sigma_v2=exp(b_V[1,1])
gen COST=-1
gen double sigma_u2=exp(b_U[1,1])
gen eta_e=resid_BC95
gen double mui = (mu*sigma_v2- COST*eta_e*sigma_u2)/(sigma_v2+sigma_u2) 
gen double sigmai2 = sigma_v2*sigma_u2/(sigma_v2 + sigma_u2) 
gen eff_BC95_alt=1/exp(lnnormal(-(COST*sqrt(sigmai2)- (mui/sqrt(sigmai2))))-lnnormal(-(-mui/sqrt(sigmai2)))+(-COST*mui +0.5*sigmai2) ) 
replace eff_BC95_alt=. if country!=1 // The mu values for non-Australian DNSPs have not been implemented in the formula above
replace eff_BC95=eff_BC95_alt if eff_BC95==. & country==1 // Note that this fix is only applied to Aus DNSPs
replace lvchat=lvchat+ln(1/eff_BC95)
replace resid_BC95=lvc-lvchat

drop eff_BC95_alt

keep if dnsp<=13
keep eiid year eff* resid* bc
export delimited using "output/ForReportLP.csv", replace

log close
exit 




